/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IHuntable;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.EntityRabbitTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityHareTFC
extends EntityRabbitTFC
implements IHuntable {
    private static final int DAYS_TO_ADULTHOOD = 16;
    private static final DataParameter<Integer> HARE_TYPE = EntityDataManager.func_187226_a(EntityHareTFC.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHareTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityHareTFC.getRandomGrowth(16, 0));
    }

    public EntityHareTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.4f, 0.6f);
        this.field_70767_i = new EntityRabbitTFC.RabbitJumpHelper(this);
        this.field_70765_h = new EntityRabbitTFC.RabbitMoveHelper(this);
        this.setMovementSpeed(0.0);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TROPICAL_FOREST && biomeType != BiomeHelper.BiomeType.TEMPERATE_FOREST && biomeType != BiomeHelper.BiomeType.SAVANNA && biomeType != BiomeHelper.BiomeType.DESERT)) {
            return ConfigTFC.Animals.HARE.rarity;
        }
        return 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HARE_TYPE, (Object)0);
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("HareType", this.getHareType());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHareType(compound.func_74762_e("HareType"));
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_HARE;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.getRandomHareType();
        if (livingdata instanceof HareTypeData) {
            i = ((HareTypeData)livingdata).typeData;
        } else {
            livingdata = new HareTypeData(i);
        }
        this.setHareType(i);
        return livingdata;
    }

    public int getHareType() {
        return (Integer)this.field_70180_af.func_187225_a(HARE_TYPE);
    }

    public void setHareType(int hareTypeId) {
        this.field_70180_af.func_187227_b(HARE_TYPE, (Object)hareTypeId);
    }

    private int getRandomHareType() {
        float temperature = 0.0f;
        float rainfall = 0.0f;
        float floraDensity = 0.0f;
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        int i = this.field_70146_Z.nextInt(100);
        if (biomeType == BiomeHelper.BiomeType.SAVANNA) {
            return i < 50 ? 1 : (i < 90 ? 1 : 3);
        }
        if (biomeType == BiomeHelper.BiomeType.DESERT) {
            return i < 10 ? 3 : (i < 90 ? 0 : 1);
        }
        return i < 50 ? 0 : (i < 90 ? 1 : 2);
    }

    public static class HareTypeData
    implements IEntityLivingData {
        public int typeData;

        public HareTypeData(int type) {
            this.typeData = type;
        }
    }
}

